local t = Def.ActorFrame{
	InitCommand=cmd(runcommandsonleaves,cmd(ztest,true));
	LoadActor("_song frame");

	Def.Banner{
		InitCommand=cmd(x,-264;halign,0;scaletoclipped,138,40;diffusealpha,0.75;fadeleft,0.5);
		SetCommand=function(self, params)
			if params.Song then
				self:LoadFromSong( params.Song );
			end
		end;
	};
	LoadFont("_shared2")..{
		InitCommand=cmd(x,-294;y,-2;halign,0;zoom,0.6;shadowlength,1;maxwidth,270;maxheight,58);
		SetCommand=function(self, params)
			if params.Song then
				local song = params.Song;
				if song:GetDisplaySubTitle() ~= "" then
					self:y(-2);
					self:settext( params.Song:GetDisplayMainTitle() );
					self:diffuse( SONGMAN:GetSongColor(params.Song) );
				else
					self:y(10);
					self:settext( params.Song:GetDisplayFullTitle() );
					self:diffuse( SONGMAN:GetSongColor(params.Song) );
				end
			end
		end;
	};
	
	LoadFont("_shared2")..{
		InitCommand=cmd(x,-294;y,10;halign,0;zoom,0.45;shadowlength,1;maxwidth,286;maxheight,58);
		SetCommand=function(self, params)
			if params.Song then
				local song = params.Song;
				if song:GetDisplaySubTitle() ~= "" then
					self:settext( params.Song:GetDisplaySubTitle() );
					self:diffuse( SONGMAN:GetSongColor(params.Song) );
					self:visible(true);
				else
					self:settext( params.Song:GetDisplayFullTitle() );
					self:diffuse( SONGMAN:GetSongColor(params.Song) );
					self:visible(false);
				end
			end
		end;
	};
};

local c
local Scores = Def.ActorFrame{
	InitCommand=function(self) c = self:GetChildren(); end;
};

for i=1,4 do
	Scores[#Scores+1] = LoadFont("_ScreenRanking common")..{
		Name="Name"..i;
		InitCommand=cmd(x,scale(i,1,4,-48,240);y,-8;zoom,0.625);
	};
	Scores[#Scores+1] = LoadFont("PaneDisplay text")..{
		Name="Score"..i;
		InitCommand=cmd(x,scale(i,1,4,-48,240);y,12;zoom,1.125);
	};
end

Scores.SetCommand=function(self,param)
	local profile = PROFILEMAN:GetMachineProfile();
	for name, child in pairs(c) do child:visible(false); end
	local sel = param.Song
	if not sel then return end

	for i, item in pairs(param.Entries) do
		if item then
			local hsl = profile:GetHighScoreList(sel, item);
			local hs = hsl and hsl:GetHighScores();

			assert(c["Name"..i])
			assert(c["Score"..i])

			c["Name"..i]:visible(true)
			c["Score"..i]:visible(true)
			if hs and #hs > 0 then
				if hs[1]:GetPercentDP()*100.0 == 100 then
					c["Name"..i]:settext( hs[1]:GetName() );
					c["Score"..i]:settext( "100%" );
					c["Score"..i]:zoomx(1.2);
					c["Score"..i]:diffuse(color("1,1,1,1"));
				elseif (hs[1]:GetPercentDP()*100.0 >= 80.0) then
					c["Name"..i]:settext( hs[1]:GetName() );
					c["Score"..i]:settext( FormatPercentScore( hs[1]:GetPercentDP() ) );
					c["Score"..i]:diffuse(color("1,1,1,1"));
				else
					c["Name"..i]:settext( hs[1]:GetName() );
					c["Score"..i]:settext( FormatPercentScore( hs[1]:GetPercentDP() ) );
					c["Score"..i]:diffuse(color("0.775,0.775,0.775,1"));
				end
			else
				c["Name"..i]:settext( "---" );
				c["Name"..i]:diffuse(color("1,1,1,0.75"));
				c["Score"..i]:settext( "0%");
				c["Score"..i]:diffuse(color("1,1,1,0.75"));
			end
		end
	end
end;

t[#t+1] = Scores

return t